/*
 * Decompiled with CFR 0.152.
 */
package jace.tracker;

import jace.hardware.mockingboard.Card;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class PlaybackEngine {
    static final int BITS = 16;
    static final int RATE = 44100;
    SourceDataLine sdl;
    AudioFormat af = new AudioFormat(44100.0f, 16, 2, true, true);
    static final int BUFFER_SIZE = 5512;
    byte[] dataBuffer = new byte[22048];
    int[] leftBuffer = new int[5512];
    int[] rightBuffer = new int[5512];
    Card soundGen = null;
    LineListener listener = new LineListener(){

        @Override
        public void update(LineEvent e) {
            PlaybackEngine.this.play();
        }
    };
    Thread thread;
    boolean isPlaying = false;

    public PlaybackEngine(Card gen) {
        this.soundGen = gen;
        try {
            this.init();
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws LineUnavailableException {
        Line l;
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, this.af);
        if (AudioSystem.isLineSupported(dli)) {
            l = null;
            l = AudioSystem.getLine(dli);
            if (!(l instanceof SourceDataLine)) {
                throw new LineUnavailableException("Line is not an output line!");
            }
        } else {
            throw new LineUnavailableException("Line not supported!");
        }
        this.sdl = (SourceDataLine)l;
        if (this.sdl == null) {
            throw new LineUnavailableException("line not found");
        }
    }

    public void startPlayback() throws LineUnavailableException {
        if (!this.isPlaying) {
            this.isPlaying = true;
            this.sdl.addLineListener(this.listener);
            this.sdl.open(this.af);
            this.sdl.start();
        }
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(){

                @Override
                public void run() {
                    while (PlaybackEngine.this.isPlaying) {
                        PlaybackEngine.this.play();
                    }
                }
            };
            this.thread.start();
        }
    }

    public void stopPlayback() {
        this.isPlaying = false;
        this.sdl.stop();
        this.sdl.flush();
        this.sdl.removeLineListener(this.listener);
    }

    protected void finalize() throws Throwable {
        this.stopPlayback();
    }

    public void forcePlay() {
        if (this.sdl != null && this.sdl.isActive() && this.sdl.isOpen()) {
            this.sdl.flush();
            this.play();
        }
    }

    public void play() {
        int size = Math.min(this.sdl.available() / 4, 5512);
        while (size < 1378) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            size = Math.min(this.sdl.available() / 4, 5512);
        }
        if (this.soundGen != null) {
            this.soundGen.playSound(size, this.leftBuffer, this.rightBuffer);
        } else {
            System.out.println("NO GENERATOR IS PRESENT!");
        }
        for (int i = 0; i < size; ++i) {
            this.dataBuffer[i * 4] = (byte)((this.leftBuffer[i] & 0xFF00) >>> 8);
            this.dataBuffer[i * 4 + 1] = (byte)(this.leftBuffer[i] & 0xFF);
            this.dataBuffer[i * 4 + 2] = (byte)((this.rightBuffer[i] & 0xFF00) >>> 8);
            this.dataBuffer[i * 4 + 3] = (byte)(this.rightBuffer[i] & 0xFF);
        }
        this.sdl.write(this.dataBuffer, 0, size * 4);
    }
}

